/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.function.Consumer;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public record OwnerData(String name, String uuid, boolean showInTooltip) implements TooltipProvider
{
    public static final OwnerData DEFAULT = new OwnerData("", "", false);
    public static final Codec<OwnerData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(OwnerData::name), (App)Codec.STRING.fieldOf("uuid").forGetter(OwnerData::uuid), (App)Codec.BOOL.fieldOf("show_in_tooltip").forGetter(OwnerData::showInTooltip)).apply((Applicative)instance, OwnerData::new));
    public static final StreamCodec<ByteBuf, OwnerData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, OwnerData::name, (StreamCodec)ByteBufCodecs.STRING_UTF8, OwnerData::uuid, (StreamCodec)ByteBufCodecs.BOOL, OwnerData::showInTooltip, OwnerData::new);

    public void addToTooltip(Item.TooltipContext ctx, Consumer<Component> lineAdder, TooltipFlag flag) {
        if (this.showInTooltip) {
            lineAdder.accept((Component)Component.translatable((String)"tooltip.securitycraft.component.owner", (Object[])new Object[]{this.name}).setStyle(Utils.GRAY_STYLE));
        }
    }

    public OwnerData setOwnerName(String name) {
        return new OwnerData(name, this.uuid, this.showInTooltip);
    }

    public OwnerData setOwnerUUID(String uuid) {
        return new OwnerData(this.name, uuid, this.showInTooltip);
    }

    public Owner toOwner() {
        return new Owner(this.name, this.uuid);
    }

    public static OwnerData fromOwner(Owner owner, boolean showInTooltip) {
        return new OwnerData(owner.getName(), owner.getUUID(), showInTooltip);
    }

    public static OwnerData fromPlayer(Player player, boolean showInTooltip) {
        return new OwnerData(player.getName().getString(), player.getUUID().toString(), showInTooltip);
    }
}

