/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.components.GlobalPositionComponent;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record GlobalPositions(List<GlobalPos> positions) implements GlobalPositionComponent<GlobalPositions, GlobalPos, Void>
{
    public static Codec<GlobalPositions> codec(int size) {
        return RecordCodecBuilder.create(instance -> instance.group((App)GlobalPositionComponent.nullableSizedCodec(GlobalPos.CODEC, size).fieldOf("positions").forGetter(GlobalPositions::positions)).apply((Applicative)instance, GlobalPositions::new));
    }

    public static StreamCodec<ByteBuf, GlobalPositions> streamCodec(int size) {
        return StreamCodec.composite(GlobalPositionComponent.nullableSizedStreamCodec(GlobalPos.STREAM_CODEC, size, DUMMY_GLOBAL_POS), GlobalPositions::positions, GlobalPositions::new);
    }

    public static GlobalPositions sized(int size) {
        return new GlobalPositions(Arrays.asList(new GlobalPos[size]));
    }

    @Override
    public boolean isPositionAdded(GlobalPos globalPos) {
        return globalPos != null && this.positions.contains(globalPos);
    }

    @Override
    public GlobalPos getGlobalPos(GlobalPos globalPos) {
        return globalPos;
    }

    @Override
    public GlobalPos createEntry(GlobalPos globalPos, Void extra) {
        return globalPos;
    }

    @Override
    public void setOnStack(Supplier<DataComponentType<GlobalPositions>> dataComponentType, ItemStack stack, List<GlobalPos> newPositionList) {
        stack.set(dataComponentType, (Object)new GlobalPositions(newPositionList));
    }

    public boolean add(Supplier<DataComponentType<GlobalPositions>> boundCameras, ItemStack stack, GlobalPos globalPos) {
        return this.add(boundCameras, stack, globalPos, null);
    }
}

