/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.IDoorActivator;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.blockentities.AllowlistOnlyBlockEntity;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class ReinforcedPressurePlateBlock
extends PressurePlateBlock
implements IReinforcedBlock,
EntityBlock {
    private final Block vanillaBlock;

    public ReinforcedPressurePlateBlock(BlockBehaviour.Properties properties, Block vanillaBlock, BlockSetType blockSetType) {
        super(blockSetType, properties);
        this.vanillaBlock = vanillaBlock;
        DoorActivator.addActivator((Block)this);
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return BlockUtils.getDestroyProgress((x$0, x$1, x$2, x$3) -> super.getDestroyProgress(x$0, x$1, x$2, x$3), state, player, level, pos);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        int redstoneStrength = this.getSignalForState(state);
        if (!level.isClientSide && redstoneStrength == 0 && entity instanceof Player) {
            AllowlistOnlyBlockEntity be;
            Player player = (Player)entity;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof AllowlistOnlyBlockEntity && this.isAllowedToPress(be = (AllowlistOnlyBlockEntity)blockEntity, player)) {
                this.checkPressed((Entity)player, level, pos, state, redstoneStrength);
            }
        }
    }

    protected int getSignalStrength(Level level, BlockPos pos) {
        Object object;
        AABB aabb = TOUCH_AABB.move(pos);
        List list = level.getEntities(null, aabb);
        if (!list.isEmpty() && (object = level.getBlockEntity(pos)) instanceof AllowlistOnlyBlockEntity) {
            AllowlistOnlyBlockEntity be = (AllowlistOnlyBlockEntity)object;
            for (Entity entity : list) {
                Player player;
                if (!(entity instanceof Player) || !this.isAllowedToPress(be, player = (Player)entity)) continue;
                return 15;
            }
        }
        return 0;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (player.isCreative() && (blockEntity = level.getBlockEntity(pos)) instanceof IModuleInventory) {
            IModuleInventory inv = (IModuleInventory)blockEntity;
            inv.getInventory().clear();
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity;
            if (!((Boolean)ConfigHandler.SERVER.vanillaToolBlockBreaking.get()).booleanValue() && (blockEntity = level.getBlockEntity(pos)) instanceof IModuleInventory) {
                IModuleInventory inv = (IModuleInventory)blockEntity;
                inv.dropAllModules();
            }
            if (!isMoving && this.getSignalForState(state) > 0) {
                level.updateNeighborsAt(pos, (Block)this);
                level.updateNeighborsAt(pos.below(), (Block)this);
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public boolean isAllowedToPress(AllowlistOnlyBlockEntity be, Player entity) {
        return be.isOwnedBy((Entity)entity) || be.isAllowed((Entity)entity);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            NeoForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
        }
    }

    @Override
    public Block getVanillaBlock() {
        return this.vanillaBlock;
    }

    @Override
    public BlockState convertToReinforced(Level level, BlockPos pos, BlockState vanillaState) {
        return this.defaultBlockState();
    }

    @Override
    public BlockState convertToVanilla(Level level, BlockPos pos, BlockState reinforcedState) {
        return this.getVanillaBlock().defaultBlockState();
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AllowlistOnlyBlockEntity(pos, state);
    }

    public static class DoorActivator
    implements IDoorActivator {
        private static final List<Block> BLOCKS = new ArrayList<Block>();

        public static boolean addActivator(Block block) {
            if (BLOCKS.contains(block)) {
                return false;
            }
            return BLOCKS.add(block);
        }

        @Override
        public boolean isPowering(Level level, BlockPos pos, BlockState state, BlockEntity be, Direction direction, int distance) {
            return (Boolean)state.getValue((Property)PressurePlateBlock.POWERED) != false && (distance < 2 || direction == Direction.UP);
        }

        @Override
        public List<Block> getBlocks() {
            return BLOCKS;
        }
    }
}

