/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IExtractionBlock;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.blockentities.ReinforcedHopperBlockEntity;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;

public class ReinforcedHopperBlock
extends HopperBlock
implements IReinforcedBlock,
IOverlayDisplay,
IDisguisable {
    public ReinforcedHopperBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        BlockState disguisedState = IDisguisable.getDisguisedBlockState(level.getBlockEntity(pos)).orElse(state);
        if (disguisedState.getBlock() != state.getBlock()) {
            return disguisedState.getDestroyProgress(player, level, pos);
        }
        return BlockUtils.getDestroyProgress((x$0, x$1, x$2, x$3) -> super.getDestroyProgress(x$0, x$1, x$2, x$3), state, player, level, pos);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            NeoForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
        }
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        ReinforcedHopperBlockEntity be;
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof ReinforcedHopperBlockEntity && ((be = (ReinforcedHopperBlockEntity)blockEntity).isOwnedBy((Entity)player) || be.isAllowed((Entity)player))) {
            player.openMenu((MenuProvider)be);
        }
        return InteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof ReinforcedHopperBlockEntity) {
            ReinforcedHopperBlockEntity be = (ReinforcedHopperBlockEntity)blockEntity;
            if (isMoving) {
                be.clearContent();
            }
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ReinforcedHopperBlockEntity) {
            ReinforcedHopperBlockEntity be = (ReinforcedHopperBlockEntity)blockEntity;
            HopperBlockEntity.entityInside((Level)level, (BlockPos)pos, (BlockState)state, (Entity)entity, (HopperBlockEntity)be);
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ReinforcedHopperBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : ReinforcedHopperBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)SCContent.REINFORCED_HOPPER_BLOCK_ENTITY.get()), HopperBlockEntity::pushItemsTick);
    }

    @Override
    public Block getVanillaBlock() {
        return Blocks.HOPPER;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = IDisguisable.getDisguisedBlockState(level.getBlockEntity(pos)).orElse(state);
        if (disguisedState.getBlock() != this) {
            return disguisedState.getShape(level, pos, ctx);
        }
        return super.getShape(state, level, pos, ctx);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        AuxiliaryLightManager lightManager = level.getAuxLightManager(pos);
        int lightValue = 0;
        if (lightManager != null) {
            lightValue = lightManager.getLightAt(pos);
        }
        return lightValue > 0 ? lightValue : super.getLightEmission(state, level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        BlockState disguisedState = IDisguisable.getDisguisedBlockState(level.getBlockEntity(pos)).orElse(state);
        if (disguisedState.getBlock() != this) {
            return disguisedState.getSoundType(level, pos, entity);
        }
        return super.getSoundType(state, level, pos, entity);
    }

    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState disguisedState = IDisguisable.getDisguisedBlockState(level.getBlockEntity(pos)).orElse(state);
        if (disguisedState.getBlock() != this) {
            return disguisedState.getShadeBrightness(level, pos);
        }
        return super.getShadeBrightness(state, level, pos);
    }

    public int getLightBlock(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState disguisedState = IDisguisable.getDisguisedBlockState(level.getBlockEntity(pos)).orElse(state);
        if (disguisedState.getBlock() != this) {
            return disguisedState.getLightBlock(level, pos);
        }
        return super.getLightBlock(state, level, pos);
    }

    public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, BlockState queryState, BlockPos queryPos) {
        return IDisguisable.getDisguisedBlockState(level.getBlockEntity(pos)).orElse(state);
    }

    @Override
    public ItemStack getDisplayStack(Level level, BlockState state, BlockPos pos) {
        return this.getDisguisedStack((BlockGetter)level, pos);
    }

    @Override
    public boolean shouldShowSCInfo(Level level, BlockState state, BlockPos pos) {
        return this.getDisguisedStack((BlockGetter)level, pos).getItem() == this.asItem();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        if (IDisguisable.shouldPickBlockDisguise((BlockGetter)level, pos, player)) {
            return this.getDisguisedStack((BlockGetter)level, pos);
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public boolean hasDynamicLightEmission(BlockState state) {
        return true;
    }

    public static class ExtractionBlock
    implements IExtractionBlock {
        @Override
        public boolean canExtract(IOwnable ownable, Level level, BlockPos pos, BlockState state) {
            ReinforcedHopperBlockEntity hopperBe = (ReinforcedHopperBlockEntity)level.getBlockEntity(pos);
            if (!hopperBe.getOwner().isValidated()) {
                return false;
            }
            if (!ownable.getOwner().owns(hopperBe)) {
                if (ownable instanceof IModuleInventory) {
                    IModuleInventory inv = (IModuleInventory)((Object)ownable);
                    return inv.isAllowed(hopperBe.getOwner().getName());
                }
                return false;
            }
            return true;
        }

        @Override
        public Block getBlock() {
            return (Block)SCContent.REINFORCED_HOPPER.get();
        }
    }
}

