/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.blockentities.TrackMineBlockEntity;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class TrackMineBlock
extends RailBlock
implements IExplosive,
EntityBlock {
    public TrackMineBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public ItemInteractionResult useItemOn(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (heldItem.is((Item)SCContent.MINE_REMOTE_ACCESS_TOOL.get())) {
            return ItemInteractionResult.SUCCESS;
        }
        if (heldItem.getItem() == SCContent.WIRE_CUTTERS.get() && this.isActive(level, pos) && this.isDefusable() && this.defuseMine(level, pos)) {
            if (!player.isCreative()) {
                player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            level.playSound(null, pos, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        if (heldItem.is(Items.FLINT_AND_STEEL) && !this.isActive(level, pos) && this.activateMine(level, pos)) {
            if (!player.isCreative()) {
                player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            level.playSound(null, pos, SoundEvents.TRIPWIRE_CLICK_ON, SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return BlockUtils.getDestroyProgress((x$0, x$1, x$2, x$3) -> super.getDestroyProgress(x$0, x$1, x$2, x$3), state, player, level, pos);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            NeoForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
        }
    }

    public void onMinecartPass(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        TrackMineBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TrackMineBlockEntity && (be = (TrackMineBlockEntity)blockEntity).isActive()) {
            level.destroyBlock(pos, false);
            level.explode((Entity)cart, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), (Boolean)ConfigHandler.SERVER.smallerMineExplosion.get() != false ? 3.0f : 6.0f, ((Boolean)ConfigHandler.SERVER.shouldSpawnFire.get()).booleanValue(), BlockUtils.getExplosionInteraction());
            cart.kill();
        }
    }

    @Override
    public void explode(Level level, BlockPos pos) {
        TrackMineBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TrackMineBlockEntity && (be = (TrackMineBlockEntity)blockEntity).isActive()) {
            level.destroyBlock(pos, false);
            level.explode(null, (double)pos.getX(), (double)pos.above().getY(), (double)pos.getZ(), (Boolean)ConfigHandler.SERVER.smallerMineExplosion.get() != false ? 3.0f : 6.0f, ((Boolean)ConfigHandler.SERVER.shouldSpawnFire.get()).booleanValue(), BlockUtils.getExplosionInteraction());
        }
    }

    @Override
    public boolean activateMine(Level level, BlockPos pos) {
        TrackMineBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TrackMineBlockEntity && !(be = (TrackMineBlockEntity)blockEntity).isActive()) {
            be.activate();
            level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return true;
        }
        return false;
    }

    @Override
    public boolean defuseMine(Level level, BlockPos pos) {
        TrackMineBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TrackMineBlockEntity && (be = (TrackMineBlockEntity)blockEntity).isActive()) {
            be.deactivate();
            level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return true;
        }
        return false;
    }

    @Override
    public boolean isActive(Level level, BlockPos pos) {
        TrackMineBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        return blockEntity instanceof TrackMineBlockEntity && (be = (TrackMineBlockEntity)blockEntity).isActive();
    }

    @Override
    public boolean isDefusable() {
        return true;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TrackMineBlockEntity(pos, state);
    }
}

