/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.blockentities.DisplayCaseBlockEntity;
import net.geforcemods.securitycraft.blockentities.GlowDisplayCaseBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DisplayCaseBlock
extends OwnableBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<AttachFace> ATTACH_FACE = BlockStateProperties.ATTACH_FACE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final VoxelShape FLOOR = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0);
    public static final VoxelShape CEILING = Block.box((double)2.0, (double)10.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final VoxelShape WALL_N = Block.box((double)2.0, (double)2.0, (double)10.0, (double)14.0, (double)14.0, (double)16.0);
    public static final VoxelShape WALL_E = Block.box((double)0.0, (double)2.0, (double)2.0, (double)6.0, (double)14.0, (double)14.0);
    public static final VoxelShape WALL_S = Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)6.0);
    public static final VoxelShape WALL_W = Block.box((double)10.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
    private final boolean glowing;

    public DisplayCaseBlock(BlockBehaviour.Properties properties, boolean glowing) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(ATTACH_FACE, (Comparable)AttachFace.WALL)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.glowing = glowing;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return switch ((AttachFace)state.getValue(ATTACH_FACE)) {
            default -> throw new MatchException(null, null);
            case AttachFace.FLOOR -> FLOOR;
            case AttachFace.CEILING -> CEILING;
            case AttachFace.WALL -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case NORTH: {
                        yield WALL_N;
                    }
                    case EAST: {
                        yield WALL_E;
                    }
                    case SOUTH: {
                        yield WALL_S;
                    }
                    case WEST: {
                        yield WALL_W;
                    }
                }
                yield Shapes.empty();
            }
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        for (Direction direction : ctx.getNearestLookingDirections()) {
            BlockState state = direction.getAxis() == Direction.Axis.Y ? (BlockState)((BlockState)this.defaultBlockState().setValue(ATTACH_FACE, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite()) : (BlockState)((BlockState)this.defaultBlockState().setValue(ATTACH_FACE, (Comparable)AttachFace.WALL)).setValue((Property)FACING, (Comparable)direction.getOpposite());
            if (!state.canSurvive((LevelReader)level, pos)) continue;
            return (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).getType() == Fluids.WATER));
        }
        return null;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = this.getConnectedDirection(state).getOpposite();
        BlockPos relativePos = pos.relative(direction);
        return level.getBlockState(relativePos).isFaceSturdy((BlockGetter)level, relativePos, direction.getOpposite());
    }

    public ItemInteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack displayedStack;
        DisplayCaseBlockEntity be;
        BlockEntity blockEntity;
        if (!level.isClientSide && !heldStack.isEmpty() && (blockEntity = level.getBlockEntity(pos)) instanceof DisplayCaseBlockEntity && (be = (DisplayCaseBlockEntity)blockEntity).isOpen() && (displayedStack = be.getDisplayedStack()).isEmpty()) {
            ItemStack toAdd;
            if (player.isCreative()) {
                toAdd = heldStack.copy();
                toAdd.setCount(1);
            } else {
                toAdd = heldStack.split(1);
            }
            be.setDisplayedStack(toAdd);
            level.playSound(null, pos, this.glowing ? SoundEvents.GLOW_ITEM_FRAME_ADD_ITEM : SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof DisplayCaseBlockEntity) {
            DisplayCaseBlockEntity be = (DisplayCaseBlockEntity)blockEntity;
            if (be.isLocked() && be.disableInteractionWhenLocked(level, pos, player)) {
                MutableComponent blockName = Utils.localize(this.getDescriptionId(), new Object[0]);
                PlayerUtils.sendMessageToPlayer(player, blockName, Utils.localize("messages.securitycraft:sonic_security_system.locked", blockName), ChatFormatting.DARK_RED, false);
                return InteractionResult.SUCCESS;
            }
            if (be.isOpen()) {
                ItemStack displayedStack = be.getDisplayedStack();
                if (!displayedStack.isEmpty() && player.isShiftKeyDown()) {
                    player.addItem(displayedStack);
                    level.playSound(null, pos, this.glowing ? SoundEvents.GLOW_ITEM_FRAME_REMOVE_ITEM : SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
                    be.setDisplayedStack(ItemStack.EMPTY);
                    return InteractionResult.SUCCESS;
                }
                be.setOpen(false);
            } else if (be.isDisabled()) {
                player.displayClientMessage((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            } else if (be.verifyPasscodeSet(level, pos, be, player)) {
                if (be.isDenied((Entity)player)) {
                    if (be.sendsDenylistMessage()) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), ChatFormatting.RED);
                    }
                } else if (be.isAllowed((Entity)player)) {
                    if (be.sendsAllowlistMessage()) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), ChatFormatting.GREEN);
                    }
                    this.activate(be);
                } else {
                    be.openPasscodeGUI(level, pos, player);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void activate(DisplayCaseBlockEntity be) {
        be.setOpen(true);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (player.isCreative() && (blockEntity = level.getBlockEntity(pos)) instanceof IModuleInventory) {
            IModuleInventory inv = (IModuleInventory)blockEntity;
            inv.getInventory().clear();
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity be = level.getBlockEntity(pos);
            if (be instanceof DisplayCaseBlockEntity) {
                DisplayCaseBlockEntity displayCase = (DisplayCaseBlockEntity)be;
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)displayCase.getDisplayedStack());
            }
            if (!((Boolean)ConfigHandler.SERVER.vanillaToolBlockBreaking.get()).booleanValue() && be instanceof IModuleInventory) {
                IModuleInventory inv = (IModuleInventory)be;
                inv.dropAllModules();
            }
            if (be instanceof IPasscodeProtected) {
                IPasscodeProtected passcodeProtected = (IPasscodeProtected)be;
                SaltData.removeSalt(passcodeProtected.getSaltKey());
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Override
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return this.getConnectedDirection(state).getOpposite() == facing && !state.canSurvive((LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, pos, facingPos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        DisplayCaseBlockEntity be;
        ItemStack displayedStack;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DisplayCaseBlockEntity && !(displayedStack = (be = (DisplayCaseBlockEntity)blockEntity).getDisplayedStack()).isEmpty() && be.isOpen() && !Screen.hasControlDown()) {
            return displayedStack;
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.glowing ? new GlowDisplayCaseBlockEntity(pos, state) : new DisplayCaseBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.isClientSide) {
            if (this.glowing) {
                return DisplayCaseBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)SCContent.GLOW_DISPLAY_CASE_BLOCK_ENTITY.get()), LevelUtils::blockEntityTicker);
            }
            return DisplayCaseBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)SCContent.DISPLAY_CASE_BLOCK_ENTITY.get()), LevelUtils::blockEntityTicker);
        }
        return null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, ATTACH_FACE, WATERLOGGED});
    }

    private Direction getConnectedDirection(BlockState state) {
        return switch ((AttachFace)state.getValue(ATTACH_FACE)) {
            case AttachFace.CEILING -> Direction.DOWN;
            case AttachFace.FLOOR -> Direction.UP;
            default -> (Direction)state.getValue((Property)FACING);
        };
    }
}

