/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.LinkedBlock;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class LinkableBlockEntity
extends CustomizableBlockEntity
implements ITickingBlockEntity {
    protected List<LinkedBlock> linkedBlocks = new ArrayList<LinkedBlock>();
    private ListTag nbtTagStorage = null;

    protected LinkableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (this.hasLevel() && this.nbtTagStorage != null) {
            this.readLinkedBlocks(this.nbtTagStorage);
            level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            this.nbtTagStorage = null;
        }
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        if (tag.contains("linkedBlocks")) {
            if (!this.hasLevel()) {
                this.nbtTagStorage = tag.getList("linkedBlocks", 10);
                return;
            }
            this.readLinkedBlocks(tag.getList("linkedBlocks", 10));
        }
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(tag, lookupProvider);
        if (!this.linkedBlocks.isEmpty()) {
            ListTag tagList = new ListTag();
            for (LinkedBlock block : this.linkedBlocks) {
                CompoundTag toAppend = new CompoundTag();
                if (block != null) {
                    toAppend.putString("blockName", block.getBlockName());
                    toAppend.putInt("blockX", block.getX());
                    toAppend.putInt("blockY", block.getY());
                    toAppend.putInt("blockZ", block.getZ());
                }
                tagList.add((Object)toAppend);
            }
            tag.put("linkedBlocks", (Tag)tagList);
        }
    }

    public void setRemoved() {
        for (LinkedBlock block : this.linkedBlocks) {
            if (!this.level.isLoaded(block.getPos())) continue;
            LinkableBlockEntity.unlink(block.asBlockEntity(this.level), this);
        }
        super.setRemoved();
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        this.propagate(new ILinkedAction.OptionChanged<T>(option), this);
        super.onOptionChanged(option);
    }

    private void readLinkedBlocks(ListTag list) {
        for (int i = 0; i < list.size(); ++i) {
            String name = list.getCompound(i).getString("blockName");
            int x = list.getCompound(i).getInt("blockX");
            int y = list.getCompound(i).getInt("blockY");
            int z = list.getCompound(i).getInt("blockZ");
            LinkedBlock block = new LinkedBlock(name, new BlockPos(x, y, z));
            if (!this.hasLevel() || !this.level.isLoaded(block.getPos()) || !block.validate(this.level) || this.linkedBlocks.contains(block)) continue;
            LinkableBlockEntity.link(this, block.asBlockEntity(this.level));
        }
    }

    public static void link(LinkableBlockEntity blockEntity1, LinkableBlockEntity blockEntity2) {
        if (LinkableBlockEntity.isLinkedWith(blockEntity1, blockEntity2)) {
            return;
        }
        LinkedBlock block1 = new LinkedBlock(blockEntity1);
        LinkedBlock block2 = new LinkedBlock(blockEntity2);
        if (!blockEntity1.linkedBlocks.contains(block2)) {
            blockEntity1.linkedBlocks.add(block2);
            blockEntity1.setChanged();
        }
        if (!blockEntity2.linkedBlocks.contains(block1)) {
            blockEntity2.linkedBlocks.add(block1);
            blockEntity2.setChanged();
        }
    }

    public static void unlink(LinkableBlockEntity blockEntity1, LinkableBlockEntity blockEntity2) {
        if (blockEntity1 == null || blockEntity2 == null) {
            return;
        }
        LinkedBlock block = new LinkedBlock(blockEntity2);
        if (blockEntity1.linkedBlocks.contains(block)) {
            blockEntity1.linkedBlocks.remove(block);
            blockEntity1.setChanged();
        }
    }

    public static boolean isLinkedWith(LinkableBlockEntity blockEntity1, LinkableBlockEntity blockEntity2) {
        return blockEntity1.linkedBlocks.contains(new LinkedBlock(blockEntity2)) && blockEntity2.linkedBlocks.contains(new LinkedBlock(blockEntity1));
    }

    public void propagate(ILinkedAction action, LinkableBlockEntity excludedBE) {
        ArrayList<LinkableBlockEntity> list = new ArrayList<LinkableBlockEntity>();
        list.add(excludedBE);
        this.propagate(action, list);
    }

    public void propagate(ILinkedAction action, List<LinkableBlockEntity> excludedBEs) {
        Iterator<LinkedBlock> linkedBlockIterator = this.linkedBlocks.iterator();
        while (linkedBlockIterator.hasNext()) {
            LinkedBlock block = linkedBlockIterator.next();
            if (!this.level.isLoaded(block.getPos()) || excludedBEs.contains(block.asBlockEntity(this.level))) continue;
            if (block.validate(this.level)) {
                BlockState state = this.level.getBlockState(block.getPos());
                block.asBlockEntity(this.level).onLinkedBlockAction(action, excludedBEs);
                this.level.sendBlockUpdated(block.getPos(), state, state, 3);
                continue;
            }
            linkedBlockIterator.remove();
        }
    }

    protected void onLinkedBlockAction(ILinkedAction action, List<LinkableBlockEntity> excludedBEs) {
    }
}

