/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySynchronization;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPreset;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import net.neoforged.neoforge.registries.DataPackRegistriesHooks;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.slf4j.Logger;

public class RegistryDataLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final RegistrationInfo NETWORK_REGISTRATION_INFO = new RegistrationInfo(Optional.empty(), Lifecycle.experimental());
    private static final Function<Optional<KnownPack>, RegistrationInfo> REGISTRATION_INFO_CACHE = Util.memoize(p_325559_ -> {
        Lifecycle lifecycle = p_325559_.map(KnownPack::isVanilla).map(p_325560_ -> Lifecycle.stable()).orElse(Lifecycle.experimental());
        return new RegistrationInfo(p_325559_, lifecycle);
    });
    public static final List<RegistryData<?>> WORLDGEN_REGISTRIES = List.of(new RegistryData<DimensionType>(Registries.DIMENSION_TYPE, DimensionType.DIRECT_CODEC), new RegistryData<Biome>(Registries.BIOME, Biome.DIRECT_CODEC), new RegistryData<ChatType>(Registries.CHAT_TYPE, ChatType.DIRECT_CODEC), new RegistryData(Registries.CONFIGURED_CARVER, ConfiguredWorldCarver.DIRECT_CODEC), new RegistryData(Registries.CONFIGURED_FEATURE, ConfiguredFeature.DIRECT_CODEC), new RegistryData<PlacedFeature>(Registries.PLACED_FEATURE, PlacedFeature.DIRECT_CODEC), new RegistryData<Structure>(Registries.STRUCTURE, Structure.DIRECT_CODEC), new RegistryData<StructureSet>(Registries.STRUCTURE_SET, StructureSet.DIRECT_CODEC), new RegistryData<StructureProcessorList>(Registries.PROCESSOR_LIST, StructureProcessorType.DIRECT_CODEC), new RegistryData<StructureTemplatePool>(Registries.TEMPLATE_POOL, StructureTemplatePool.DIRECT_CODEC), new RegistryData<NoiseGeneratorSettings>(Registries.NOISE_SETTINGS, NoiseGeneratorSettings.DIRECT_CODEC), new RegistryData<NormalNoise.NoiseParameters>(Registries.NOISE, NormalNoise.NoiseParameters.DIRECT_CODEC), new RegistryData<DensityFunction>(Registries.DENSITY_FUNCTION, DensityFunction.DIRECT_CODEC), new RegistryData<WorldPreset>(Registries.WORLD_PRESET, WorldPreset.DIRECT_CODEC), new RegistryData<FlatLevelGeneratorPreset>(Registries.FLAT_LEVEL_GENERATOR_PRESET, FlatLevelGeneratorPreset.DIRECT_CODEC), new RegistryData<TrimPattern>(Registries.TRIM_PATTERN, TrimPattern.DIRECT_CODEC), new RegistryData<TrimMaterial>(Registries.TRIM_MATERIAL, TrimMaterial.DIRECT_CODEC), new RegistryData<WolfVariant>(Registries.WOLF_VARIANT, WolfVariant.DIRECT_CODEC, true), new RegistryData<PaintingVariant>(Registries.PAINTING_VARIANT, PaintingVariant.DIRECT_CODEC, true), new RegistryData<DamageType>(Registries.DAMAGE_TYPE, DamageType.DIRECT_CODEC), new RegistryData<MultiNoiseBiomeSourceParameterList>(Registries.MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST, MultiNoiseBiomeSourceParameterList.DIRECT_CODEC), new RegistryData<BannerPattern>(Registries.BANNER_PATTERN, BannerPattern.DIRECT_CODEC), new RegistryData<Enchantment>(Registries.ENCHANTMENT, Enchantment.DIRECT_CODEC), new RegistryData<EnchantmentProvider>(Registries.ENCHANTMENT_PROVIDER, EnchantmentProvider.DIRECT_CODEC), new RegistryData<JukeboxSong>(Registries.JUKEBOX_SONG, JukeboxSong.DIRECT_CODEC));
    public static final List<RegistryData<?>> DIMENSION_REGISTRIES = List.of(new RegistryData<LevelStem>(Registries.LEVEL_STEM, LevelStem.CODEC));
    public static final List<RegistryData<?>> SYNCHRONIZED_REGISTRIES = DataPackRegistriesHooks.grabNetworkableRegistries(List.of(new RegistryData<Biome>(Registries.BIOME, Biome.NETWORK_CODEC), new RegistryData<ChatType>(Registries.CHAT_TYPE, ChatType.DIRECT_CODEC), new RegistryData<TrimPattern>(Registries.TRIM_PATTERN, TrimPattern.DIRECT_CODEC), new RegistryData<TrimMaterial>(Registries.TRIM_MATERIAL, TrimMaterial.DIRECT_CODEC), new RegistryData<WolfVariant>(Registries.WOLF_VARIANT, WolfVariant.DIRECT_CODEC, true), new RegistryData<PaintingVariant>(Registries.PAINTING_VARIANT, PaintingVariant.DIRECT_CODEC, true), new RegistryData<DimensionType>(Registries.DIMENSION_TYPE, DimensionType.DIRECT_CODEC), new RegistryData<DamageType>(Registries.DAMAGE_TYPE, DamageType.DIRECT_CODEC), new RegistryData<BannerPattern>(Registries.BANNER_PATTERN, BannerPattern.DIRECT_CODEC), new RegistryData<Enchantment>(Registries.ENCHANTMENT, Enchantment.DIRECT_CODEC), new RegistryData<JukeboxSong>(Registries.JUKEBOX_SONG, JukeboxSong.DIRECT_CODEC)));

    public static RegistryAccess.Frozen load(ResourceManager p_252046_, RegistryAccess p_249916_, List<RegistryData<?>> p_250344_) {
        return RegistryDataLoader.load((Loader<?> p_321412_, RegistryOps.RegistryInfoLookup p_321413_) -> p_321412_.loadFromResources(p_252046_, p_321413_), p_249916_, p_250344_);
    }

    public static RegistryAccess.Frozen load(Map<ResourceKey<? extends Registry<?>>, List<RegistrySynchronization.PackedRegistryEntry>> p_321642_, ResourceProvider p_326068_, RegistryAccess p_321850_, List<RegistryData<?>> p_321716_) {
        return RegistryDataLoader.load((Loader<?> p_325557_, RegistryOps.RegistryInfoLookup p_325558_) -> p_325557_.loadFromNetwork(p_321642_, p_326068_, p_325558_), p_321850_, p_321716_);
    }

    private static RegistryAccess.Frozen load(LoadingFunction p_321713_, RegistryAccess p_321583_, List<RegistryData<?>> p_321856_) {
        HashMap map = new HashMap();
        List<Loader<?>> list = p_321856_.stream().map(p_321410_ -> p_321410_.create(Lifecycle.stable(), map)).collect(Collectors.toUnmodifiableList());
        RegistryOps.RegistryInfoLookup registryops$registryinfolookup = RegistryDataLoader.createContext(p_321583_, list);
        list.forEach(p_321416_ -> p_321713_.apply((Loader<?>)p_321416_, registryops$registryinfolookup));
        list.forEach(p_344258_ -> {
            WritableRegistry registry = p_344258_.registry();
            try {
                registry.freeze();
            }
            catch (Exception exception) {
                map.put(registry.key(), exception);
            }
            if (p_344258_.data.requiredNonEmpty && registry.size() == 0) {
                map.put(registry.key(), new IllegalStateException("Registry must be non-empty"));
            }
        });
        if (!map.isEmpty()) {
            RegistryDataLoader.logErrors(map);
            throw new IllegalStateException("Failed to load registries due to above errors");
        }
        return new RegistryAccess.ImmutableRegistryAccess(list.stream().map(Loader::registry).toList()).freeze();
    }

    private static RegistryOps.RegistryInfoLookup createContext(RegistryAccess p_256568_, List<Loader<?>> p_255821_) {
        final HashMap map = new HashMap();
        p_256568_.registries().forEach(p_255505_ -> map.put(p_255505_.key(), RegistryDataLoader.createInfoForContextRegistry(p_255505_.value())));
        p_255821_.forEach(p_344256_ -> map.put(p_344256_.registry.key(), RegistryDataLoader.createInfoForNewRegistry(p_344256_.registry)));
        return new RegistryOps.RegistryInfoLookup(){

            @Override
            public <T> Optional<RegistryOps.RegistryInfo<T>> lookup(ResourceKey<? extends Registry<? extends T>> p_256014_) {
                return Optional.ofNullable((RegistryOps.RegistryInfo)map.get(p_256014_));
            }
        };
    }

    private static <T> RegistryOps.RegistryInfo<T> createInfoForNewRegistry(WritableRegistry<T> p_256020_) {
        return new RegistryOps.RegistryInfo(p_256020_.asLookup(), p_256020_.createRegistrationLookup(), p_256020_.registryLifecycle());
    }

    private static <T> RegistryOps.RegistryInfo<T> createInfoForContextRegistry(Registry<T> p_256230_) {
        return new RegistryOps.RegistryInfo<T>(p_256230_.asLookup(), p_256230_.asTagAddingLookup(), p_256230_.registryLifecycle());
    }

    private static void logErrors(Map<ResourceKey<?>, Exception> p_252325_) {
        StringWriter stringwriter = new StringWriter();
        PrintWriter printwriter = new PrintWriter(stringwriter);
        Map<ResourceLocation, Map<ResourceLocation, Exception>> map = p_252325_.entrySet().stream().collect(Collectors.groupingBy(p_249353_ -> ((ResourceKey)p_249353_.getKey()).registry(), Collectors.toMap(p_251444_ -> ((ResourceKey)p_251444_.getKey()).location(), Map.Entry::getValue)));
        map.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(p_249838_ -> {
            printwriter.printf("> Errors in registry %s:%n", p_249838_.getKey());
            ((Map)p_249838_.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(p_250688_ -> {
                printwriter.printf(">> Errors in element %s:%n", p_250688_.getKey());
                ((Exception)p_250688_.getValue()).printStackTrace(printwriter);
            });
        });
        printwriter.flush();
        LOGGER.error("Registry loading errors:\n{}", (Object)stringwriter);
    }

    private static <E> void loadElementFromResource(WritableRegistry<E> p_326195_, Decoder<E> p_326476_, RegistryOps<JsonElement> p_325932_, ResourceKey<E> p_326054_, Resource p_326141_, RegistrationInfo p_326033_) throws IOException {
        Codec decoder = ConditionalOps.createConditionalCodec((Codec)NeoForgeExtraCodecs.decodeOnly(p_326476_));
        try (BufferedReader reader = p_326141_.openAsReader();){
            JsonElement jsonelement = JsonParser.parseReader((Reader)reader);
            DataResult dataresult = decoder.parse(p_325932_, (Object)jsonelement);
            Optional candidate = (Optional)dataresult.getOrThrow();
            candidate.ifPresentOrElse(e -> p_326195_.register(p_326054_, e, p_326033_), () -> LOGGER.debug("Skipping loading registry entry {} as its conditions were not met", (Object)p_326054_));
        }
    }

    static <E> void loadContentsFromManager(ResourceManager p_321535_, RegistryOps.RegistryInfoLookup p_321612_, WritableRegistry<E> p_321557_, Decoder<E> p_321820_, Map<ResourceKey<?>, Exception> p_321649_) {
        String s = Registries.elementsDirPath(p_321557_.key());
        FileToIdConverter filetoidconverter = FileToIdConverter.json(s);
        ConditionalOps registryops = new ConditionalOps(RegistryOps.create(JsonOps.INSTANCE, p_321612_), ICondition.IContext.TAGS_INVALID);
        for (Map.Entry<ResourceLocation, Resource> entry : filetoidconverter.listMatchingResources(p_321535_).entrySet()) {
            ResourceLocation resourcelocation = entry.getKey();
            ResourceKey resourcekey = ResourceKey.create(p_321557_.key(), filetoidconverter.fileToId(resourcelocation));
            Resource resource = entry.getValue();
            RegistrationInfo registrationinfo = REGISTRATION_INFO_CACHE.apply(resource.knownPackInfo());
            try {
                RegistryDataLoader.loadElementFromResource(p_321557_, p_321820_, (RegistryOps<JsonElement>)registryops, resourcekey, resource, registrationinfo);
            }
            catch (Exception exception) {
                p_321649_.put(resourcekey, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse %s from pack %s", resourcelocation, resource.sourcePackId()), exception));
            }
        }
    }

    static <E> void loadContentsFromNetwork(Map<ResourceKey<? extends Registry<?>>, List<RegistrySynchronization.PackedRegistryEntry>> p_321633_, ResourceProvider p_326020_, RegistryOps.RegistryInfoLookup p_321801_, WritableRegistry<E> p_321671_, Decoder<E> p_321718_, Map<ResourceKey<?>, Exception> p_321625_) {
        List<RegistrySynchronization.PackedRegistryEntry> list = p_321633_.get(p_321671_.key());
        if (list != null) {
            RegistryOps registryops = RegistryOps.create(NbtOps.INSTANCE, p_321801_);
            RegistryOps<JsonElement> registryops1 = RegistryOps.create(JsonOps.INSTANCE, p_321801_);
            String s = Registries.elementsDirPath(p_321671_.key());
            FileToIdConverter filetoidconverter = FileToIdConverter.json(s);
            for (RegistrySynchronization.PackedRegistryEntry registrysynchronization$packedregistryentry : list) {
                ResourceKey resourcekey = ResourceKey.create(p_321671_.key(), registrysynchronization$packedregistryentry.id());
                Optional optional = registrysynchronization$packedregistryentry.data();
                if (optional.isPresent()) {
                    try {
                        DataResult dataresult = p_321718_.parse(registryops, (Object)((Tag)optional.get()));
                        Object e = dataresult.getOrThrow();
                        p_321671_.register(resourcekey, e, NETWORK_REGISTRATION_INFO);
                    }
                    catch (Exception exception) {
                        p_321625_.put(resourcekey, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse value %s from server", optional.get()), exception));
                    }
                    continue;
                }
                ResourceLocation resourcelocation = filetoidconverter.idToFile(registrysynchronization$packedregistryentry.id());
                try {
                    Resource resource = p_326020_.getResourceOrThrow(resourcelocation);
                    RegistryDataLoader.loadElementFromResource(p_321671_, p_321718_, registryops1, resourcekey, resource, NETWORK_REGISTRATION_INFO);
                }
                catch (Exception exception1) {
                    p_321625_.put(resourcekey, new IllegalStateException("Failed to parse local data", exception1));
                }
            }
        }
    }

    @FunctionalInterface
    static interface LoadingFunction {
        public void apply(Loader<?> var1, RegistryOps.RegistryInfoLookup var2);
    }

    record Loader<T>(RegistryData<T> data, WritableRegistry<T> registry, Map<ResourceKey<?>, Exception> loadingErrors) {
        public void loadFromResources(ResourceManager p_321702_, RegistryOps.RegistryInfoLookup p_321840_) {
            RegistryDataLoader.loadContentsFromManager(p_321702_, p_321840_, this.registry, this.data.elementCodec, this.loadingErrors);
        }

        public void loadFromNetwork(Map<ResourceKey<? extends Registry<?>>, List<RegistrySynchronization.PackedRegistryEntry>> p_321562_, ResourceProvider p_326419_, RegistryOps.RegistryInfoLookup p_321617_) {
            RegistryDataLoader.loadContentsFromNetwork(p_321562_, p_326419_, p_321617_, this.registry, this.data.elementCodec, this.loadingErrors);
        }
    }

    public record RegistryData<T>(ResourceKey<? extends Registry<T>> key, Codec<T> elementCodec, boolean requiredNonEmpty, Consumer<RegistryBuilder<T>> registryBuilderConsumer) {
        public RegistryData(ResourceKey<? extends Registry<T>> key, Codec<T> elementCodec, boolean requiredNonEmpty) {
            this(key, elementCodec, requiredNonEmpty, registryBuilder -> {});
        }

        RegistryData(ResourceKey<? extends Registry<T>> p_251360_, Codec<T> p_248976_) {
            this(p_251360_, p_248976_, false);
        }

        Loader<T> create(Lifecycle p_251662_, Map<ResourceKey<?>, Exception> p_251565_) {
            RegistryBuilder registryBuilder = new RegistryBuilder(this.key);
            this.registryBuilderConsumer.accept(registryBuilder);
            WritableRegistry writableregistry = (WritableRegistry)registryBuilder.disableRegistrationCheck().create();
            return new Loader(this, writableregistry, p_251565_);
        }

        public void runWithArguments(BiConsumer<ResourceKey<? extends Registry<T>>, Codec<T>> p_312899_) {
            p_312899_.accept(this.key, this.elementCodec);
        }
    }
}

