/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.accesstransformer;

import java.util.Objects;
import java.util.Set;
import net.neoforged.accesstransformer.AccessTransformer;
import net.neoforged.accesstransformer.Target;
import net.neoforged.accesstransformer.TargetType;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class WildcardTarget
extends Target<ClassNode> {
    private final TargetType type;

    public WildcardTarget(String targetName, boolean isMethod) {
        super(targetName);
        this.type = isMethod ? TargetType.METHOD : TargetType.FIELD;
    }

    @Override
    public TargetType getType() {
        return TargetType.CLASS;
    }

    @Override
    public String toString() {
        return Objects.toString(this.getClassName()) + " " + this.type + "WILDCARD";
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof WildcardTarget)) {
            return false;
        }
        return super.equals(obj) && ((WildcardTarget)obj).type == this.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getClassName(), this.getType(), "WILDCARD", this.type});
    }

    @Override
    public String targetName() {
        return "*" + this.type + "*";
    }

    @Override
    public void apply(ClassNode node, AccessTransformer.Modifier targetAccess, AccessTransformer.FinalState targetFinalState, Set<String> privateChanged) {
        block3: {
            block2: {
                if (this.type != TargetType.FIELD) break block2;
                for (FieldNode fn : node.fields) {
                    fn.access = targetAccess.mergeWith(fn.access);
                    fn.access = targetFinalState.mergeWith(fn.access);
                }
                break block3;
            }
            if (this.type != TargetType.METHOD) break block3;
            for (MethodNode mn : node.methods) {
                boolean wasPrivate = (mn.access & 2) == 2;
                mn.access = targetAccess.mergeWith(mn.access);
                mn.access = targetFinalState.mergeWith(mn.access);
                if (!wasPrivate || "<init>".equals(mn.name) || (mn.access & 2) == 2) continue;
                privateChanged.add(mn.name + mn.desc);
            }
        }
    }
}

